package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingGroupName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateThingGroupRequest(
    thingGroupName: ThingGroupName,
    parentGroupName: Option[ThingGroupName] = None,
    thingGroupProperties: Option[zio.aws.iot.model.ThingGroupProperties] = None,
    tags: Option[Iterable[zio.aws.iot.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateThingGroupRequest = {
    import CreateThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateThingGroupRequest
      .builder()
      .thingGroupName(ThingGroupName.unwrap(thingGroupName): java.lang.String)
      .optionallyWith(
        parentGroupName.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.parentGroupName)
      .optionallyWith(thingGroupProperties.map(value => value.buildAwsValue()))(
        _.thingGroupProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateThingGroupRequest.ReadOnly =
    zio.aws.iot.model.CreateThingGroupRequest.wrap(buildAwsValue())
}
object CreateThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateThingGroupRequest =
      zio.aws.iot.model.CreateThingGroupRequest(
        thingGroupName,
        parentGroupName.map(value => value),
        thingGroupProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def thingGroupName: ThingGroupName
    def parentGroupName: Option[ThingGroupName]
    def thingGroupProperties
        : Option[zio.aws.iot.model.ThingGroupProperties.ReadOnly]
    def tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]]
    def getThingGroupName: ZIO[Any, Nothing, ThingGroupName] =
      ZIO.succeed(thingGroupName)
    def getParentGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("parentGroupName", parentGroupName)
    def getThingGroupProperties
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingGroupProperties.ReadOnly] =
      AwsError.unwrapOptionField("thingGroupProperties", thingGroupProperties)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iot.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateThingGroupRequest
  ) extends zio.aws.iot.model.CreateThingGroupRequest.ReadOnly {
    override val thingGroupName: ThingGroupName =
      zio.aws.iot.model.primitives.ThingGroupName(impl.thingGroupName())
    override val parentGroupName: Option[ThingGroupName] = scala
      .Option(impl.parentGroupName())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val thingGroupProperties
        : Option[zio.aws.iot.model.ThingGroupProperties.ReadOnly] = scala
      .Option(impl.thingGroupProperties())
      .map(value => zio.aws.iot.model.ThingGroupProperties.wrap(value))
    override val tags: Option[List[zio.aws.iot.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateThingGroupRequest
  ): zio.aws.iot.model.CreateThingGroupRequest.ReadOnly = new Wrapper(impl)
}
