package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{BillingGroupName, ThingTypeName, ThingName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateThingRequest(
    thingName: ThingName,
    thingTypeName: Option[ThingTypeName] = None,
    attributePayload: Option[zio.aws.iot.model.AttributePayload] = None,
    billingGroupName: Option[BillingGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateThingRequest = {
    import CreateThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(attributePayload.map(value => value.buildAwsValue()))(
        _.attributePayload
      )
      .optionallyWith(
        billingGroupName.map(value =>
          BillingGroupName.unwrap(value): java.lang.String
        )
      )(_.billingGroupName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateThingRequest.ReadOnly =
    zio.aws.iot.model.CreateThingRequest.wrap(buildAwsValue())
}
object CreateThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateThingRequest =
      zio.aws.iot.model.CreateThingRequest(
        thingName,
        thingTypeName.map(value => value),
        attributePayload.map(value => value.asEditable),
        billingGroupName.map(value => value)
      )
    def thingName: ThingName
    def thingTypeName: Option[ThingTypeName]
    def attributePayload: Option[zio.aws.iot.model.AttributePayload.ReadOnly]
    def billingGroupName: Option[BillingGroupName]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getAttributePayload
        : ZIO[Any, AwsError, zio.aws.iot.model.AttributePayload.ReadOnly] =
      AwsError.unwrapOptionField("attributePayload", attributePayload)
    def getBillingGroupName: ZIO[Any, AwsError, BillingGroupName] =
      AwsError.unwrapOptionField("billingGroupName", billingGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateThingRequest
  ) extends zio.aws.iot.model.CreateThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val thingTypeName: Option[ThingTypeName] = scala
      .Option(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val attributePayload
        : Option[zio.aws.iot.model.AttributePayload.ReadOnly] = scala
      .Option(impl.attributePayload())
      .map(value => zio.aws.iot.model.AttributePayload.wrap(value))
    override val billingGroupName: Option[BillingGroupName] = scala
      .Option(impl.billingGroupName())
      .map(value => zio.aws.iot.model.primitives.BillingGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateThingRequest
  ): zio.aws.iot.model.CreateThingRequest.ReadOnly = new Wrapper(impl)
}
