package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ThingId, ThingArn, ThingName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateThingResponse(
    thingName: Option[ThingName] = None,
    thingArn: Option[ThingArn] = None,
    thingId: Option[ThingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateThingResponse = {
    import CreateThingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateThingResponse
      .builder()
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(
        thingId.map(value => ThingId.unwrap(value): java.lang.String)
      )(_.thingId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.CreateThingResponse.ReadOnly =
    zio.aws.iot.model.CreateThingResponse.wrap(buildAwsValue())
}
object CreateThingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateThingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateThingResponse =
      zio.aws.iot.model.CreateThingResponse(
        thingName.map(value => value),
        thingArn.map(value => value),
        thingId.map(value => value)
      )
    def thingName: Option[ThingName]
    def thingArn: Option[ThingArn]
    def thingId: Option[ThingId]
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getThingId: ZIO[Any, AwsError, ThingId] =
      AwsError.unwrapOptionField("thingId", thingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateThingResponse
  ) extends zio.aws.iot.model.CreateThingResponse.ReadOnly {
    override val thingName: Option[ThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
    override val thingArn: Option[ThingArn] = scala
      .Option(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
    override val thingId: Option[ThingId] = scala
      .Option(impl.thingId())
      .map(value => zio.aws.iot.model.primitives.ThingId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateThingResponse
  ): zio.aws.iot.model.CreateThingResponse.ReadOnly = new Wrapper(impl)
}
