package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTopicRuleDestinationResponse(
    topicRuleDestination: Option[zio.aws.iot.model.TopicRuleDestination] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse = {
    import CreateTopicRuleDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse
      .builder()
      .optionallyWith(topicRuleDestination.map(value => value.buildAwsValue()))(
        _.topicRuleDestination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly =
    zio.aws.iot.model.CreateTopicRuleDestinationResponse.wrap(buildAwsValue())
}
object CreateTopicRuleDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.CreateTopicRuleDestinationResponse =
      zio.aws.iot.model.CreateTopicRuleDestinationResponse(
        topicRuleDestination.map(value => value.asEditable)
      )
    def topicRuleDestination
        : Option[zio.aws.iot.model.TopicRuleDestination.ReadOnly]
    def getTopicRuleDestination
        : ZIO[Any, AwsError, zio.aws.iot.model.TopicRuleDestination.ReadOnly] =
      AwsError.unwrapOptionField("topicRuleDestination", topicRuleDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse
  ) extends zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly {
    override val topicRuleDestination
        : Option[zio.aws.iot.model.TopicRuleDestination.ReadOnly] = scala
      .Option(impl.topicRuleDestination())
      .map(value => zio.aws.iot.model.TopicRuleDestination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse
  ): zio.aws.iot.model.CreateTopicRuleDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
