package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.DeleteScheduledAudits
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteAccountAuditConfigurationRequest(
    deleteScheduledAudits: Option[DeleteScheduledAudits] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest = {
    import DeleteAccountAuditConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest
      .builder()
      .optionallyWith(
        deleteScheduledAudits.map(value =>
          DeleteScheduledAudits.unwrap(value): java.lang.Boolean
        )
      )(_.deleteScheduledAudits)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DeleteAccountAuditConfigurationRequest.ReadOnly =
    zio.aws.iot.model.DeleteAccountAuditConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteAccountAuditConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteAccountAuditConfigurationRequest =
      zio.aws.iot.model.DeleteAccountAuditConfigurationRequest(
        deleteScheduledAudits.map(value => value)
      )
    def deleteScheduledAudits: Option[DeleteScheduledAudits]
    def getDeleteScheduledAudits: ZIO[Any, AwsError, DeleteScheduledAudits] =
      AwsError.unwrapOptionField("deleteScheduledAudits", deleteScheduledAudits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest
  ) extends zio.aws.iot.model.DeleteAccountAuditConfigurationRequest.ReadOnly {
    override val deleteScheduledAudits: Option[DeleteScheduledAudits] = scala
      .Option(impl.deleteScheduledAudits())
      .map(value => zio.aws.iot.model.primitives.DeleteScheduledAudits(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest
  ): zio.aws.iot.model.DeleteAccountAuditConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
