package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OptionalVersion, ThingGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDynamicThingGroupRequest(
    thingGroupName: ThingGroupName,
    expectedVersion: Option[OptionalVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest = {
    import DeleteDynamicThingGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest
      .builder()
      .thingGroupName(ThingGroupName.unwrap(thingGroupName): java.lang.String)
      .optionallyWith(
        expectedVersion.map(value =>
          OptionalVersion.unwrap(value): java.lang.Long
        )
      )(_.expectedVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteDynamicThingGroupRequest.ReadOnly =
    zio.aws.iot.model.DeleteDynamicThingGroupRequest.wrap(buildAwsValue())
}
object DeleteDynamicThingGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteDynamicThingGroupRequest =
      zio.aws.iot.model.DeleteDynamicThingGroupRequest(
        thingGroupName,
        expectedVersion.map(value => value)
      )
    def thingGroupName: ThingGroupName
    def expectedVersion: Option[OptionalVersion]
    def getThingGroupName: ZIO[Any, Nothing, ThingGroupName] =
      ZIO.succeed(thingGroupName)
    def getExpectedVersion: ZIO[Any, AwsError, OptionalVersion] =
      AwsError.unwrapOptionField("expectedVersion", expectedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest
  ) extends zio.aws.iot.model.DeleteDynamicThingGroupRequest.ReadOnly {
    override val thingGroupName: ThingGroupName =
      zio.aws.iot.model.primitives.ThingGroupName(impl.thingGroupName())
    override val expectedVersion: Option[OptionalVersion] = scala
      .Option(impl.expectedVersion())
      .map(value => zio.aws.iot.model.primitives.OptionalVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest
  ): zio.aws.iot.model.DeleteDynamicThingGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
