package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  NamespaceId,
  ThingName,
  ExecutionNumber,
  JobId,
  ForceFlag
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteJobExecutionRequest(
    jobId: JobId,
    thingName: ThingName,
    executionNumber: ExecutionNumber,
    force: Option[ForceFlag] = None,
    namespaceId: Option[NamespaceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest = {
    import DeleteJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .executionNumber(ExecutionNumber.unwrap(executionNumber): java.lang.Long)
      .optionallyWith(
        force.map(value => ForceFlag.unwrap(value): java.lang.Boolean)
      )(_.force)
      .optionallyWith(
        namespaceId.map(value => NamespaceId.unwrap(value): java.lang.String)
      )(_.namespaceId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DeleteJobExecutionRequest.ReadOnly =
    zio.aws.iot.model.DeleteJobExecutionRequest.wrap(buildAwsValue())
}
object DeleteJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DeleteJobExecutionRequest =
      zio.aws.iot.model.DeleteJobExecutionRequest(
        jobId,
        thingName,
        executionNumber,
        force.map(value => value),
        namespaceId.map(value => value)
      )
    def jobId: JobId
    def thingName: ThingName
    def executionNumber: ExecutionNumber
    def force: Option[ForceFlag]
    def namespaceId: Option[NamespaceId]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getExecutionNumber: ZIO[Any, Nothing, ExecutionNumber] =
      ZIO.succeed(executionNumber)
    def getForce: ZIO[Any, AwsError, ForceFlag] =
      AwsError.unwrapOptionField("force", force)
    def getNamespaceId: ZIO[Any, AwsError, NamespaceId] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest
  ) extends zio.aws.iot.model.DeleteJobExecutionRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val executionNumber: ExecutionNumber =
      zio.aws.iot.model.primitives.ExecutionNumber(impl.executionNumber())
    override val force: Option[ForceFlag] = scala
      .Option(impl.force())
      .map(value => zio.aws.iot.model.primitives.ForceFlag(value))
    override val namespaceId: Option[NamespaceId] = scala
      .Option(impl.namespaceId())
      .map(value => zio.aws.iot.model.primitives.NamespaceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest
  ): zio.aws.iot.model.DeleteJobExecutionRequest.ReadOnly = new Wrapper(impl)
}
