package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Denied(
    implicitDeny: Option[zio.aws.iot.model.ImplicitDeny] = None,
    explicitDeny: Option[zio.aws.iot.model.ExplicitDeny] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Denied = {
    import Denied.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Denied
      .builder()
      .optionallyWith(implicitDeny.map(value => value.buildAwsValue()))(
        _.implicitDeny
      )
      .optionallyWith(explicitDeny.map(value => value.buildAwsValue()))(
        _.explicitDeny
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Denied.ReadOnly =
    zio.aws.iot.model.Denied.wrap(buildAwsValue())
}
object Denied {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Denied] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Denied = zio.aws.iot.model.Denied(
      implicitDeny.map(value => value.asEditable),
      explicitDeny.map(value => value.asEditable)
    )
    def implicitDeny: Option[zio.aws.iot.model.ImplicitDeny.ReadOnly]
    def explicitDeny: Option[zio.aws.iot.model.ExplicitDeny.ReadOnly]
    def getImplicitDeny
        : ZIO[Any, AwsError, zio.aws.iot.model.ImplicitDeny.ReadOnly] =
      AwsError.unwrapOptionField("implicitDeny", implicitDeny)
    def getExplicitDeny
        : ZIO[Any, AwsError, zio.aws.iot.model.ExplicitDeny.ReadOnly] =
      AwsError.unwrapOptionField("explicitDeny", explicitDeny)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Denied
  ) extends zio.aws.iot.model.Denied.ReadOnly {
    override val implicitDeny: Option[zio.aws.iot.model.ImplicitDeny.ReadOnly] =
      scala
        .Option(impl.implicitDeny())
        .map(value => zio.aws.iot.model.ImplicitDeny.wrap(value))
    override val explicitDeny: Option[zio.aws.iot.model.ExplicitDeny.ReadOnly] =
      scala
        .Option(impl.explicitDeny())
        .map(value => zio.aws.iot.model.ExplicitDeny.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Denied
  ): zio.aws.iot.model.Denied.ReadOnly = new Wrapper(impl)
}
