package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AuditDescription,
  SuppressIndefinitely,
  Timestamp,
  AuditCheckName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeAuditSuppressionResponse(
    checkName: Option[AuditCheckName] = None,
    resourceIdentifier: Option[zio.aws.iot.model.ResourceIdentifier] = None,
    expirationDate: Option[Timestamp] = None,
    suppressIndefinitely: Option[SuppressIndefinitely] = None,
    description: Option[AuditDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse = {
    import DescribeAuditSuppressionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse
      .builder()
      .optionallyWith(
        checkName.map(value => AuditCheckName.unwrap(value): java.lang.String)
      )(_.checkName)
      .optionallyWith(resourceIdentifier.map(value => value.buildAwsValue()))(
        _.resourceIdentifier
      )
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        suppressIndefinitely.map(value =>
          SuppressIndefinitely.unwrap(value): java.lang.Boolean
        )
      )(_.suppressIndefinitely)
      .optionallyWith(
        description.map(value =>
          AuditDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly =
    zio.aws.iot.model.DescribeAuditSuppressionResponse.wrap(buildAwsValue())
}
object DescribeAuditSuppressionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuditSuppressionResponse =
      zio.aws.iot.model.DescribeAuditSuppressionResponse(
        checkName.map(value => value),
        resourceIdentifier.map(value => value.asEditable),
        expirationDate.map(value => value),
        suppressIndefinitely.map(value => value),
        description.map(value => value)
      )
    def checkName: Option[AuditCheckName]
    def resourceIdentifier
        : Option[zio.aws.iot.model.ResourceIdentifier.ReadOnly]
    def expirationDate: Option[Timestamp]
    def suppressIndefinitely: Option[SuppressIndefinitely]
    def description: Option[AuditDescription]
    def getCheckName: ZIO[Any, AwsError, AuditCheckName] =
      AwsError.unwrapOptionField("checkName", checkName)
    def getResourceIdentifier
        : ZIO[Any, AwsError, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getSuppressIndefinitely: ZIO[Any, AwsError, SuppressIndefinitely] =
      AwsError.unwrapOptionField("suppressIndefinitely", suppressIndefinitely)
    def getDescription: ZIO[Any, AwsError, AuditDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse
  ) extends zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly {
    override val checkName: Option[AuditCheckName] = scala
      .Option(impl.checkName())
      .map(value => zio.aws.iot.model.primitives.AuditCheckName(value))
    override val resourceIdentifier
        : Option[zio.aws.iot.model.ResourceIdentifier.ReadOnly] = scala
      .Option(impl.resourceIdentifier())
      .map(value => zio.aws.iot.model.ResourceIdentifier.wrap(value))
    override val expirationDate: Option[Timestamp] = scala
      .Option(impl.expirationDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val suppressIndefinitely: Option[SuppressIndefinitely] = scala
      .Option(impl.suppressIndefinitely())
      .map(value => zio.aws.iot.model.primitives.SuppressIndefinitely(value))
    override val description: Option[AuditDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.AuditDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse
  ): zio.aws.iot.model.DescribeAuditSuppressionResponse.ReadOnly = new Wrapper(
    impl
  )
}
