package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.AuditTaskId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeAuditTaskRequest(taskId: AuditTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest = {
    import DescribeAuditTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest
      .builder()
      .taskId(AuditTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuditTaskRequest.ReadOnly =
    zio.aws.iot.model.DescribeAuditTaskRequest.wrap(buildAwsValue())
}
object DescribeAuditTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuditTaskRequest =
      zio.aws.iot.model.DescribeAuditTaskRequest(taskId)
    def taskId: AuditTaskId
    def getTaskId: ZIO[Any, Nothing, AuditTaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest
  ) extends zio.aws.iot.model.DescribeAuditTaskRequest.ReadOnly {
    override val taskId: AuditTaskId =
      zio.aws.iot.model.primitives.AuditTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest
  ): zio.aws.iot.model.DescribeAuditTaskRequest.ReadOnly = new Wrapper(impl)
}
