package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AuditCheckName,
  ScheduledAuditName,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeAuditTaskResponse(
    taskStatus: Option[zio.aws.iot.model.AuditTaskStatus] = None,
    taskType: Option[zio.aws.iot.model.AuditTaskType] = None,
    taskStartTime: Option[Timestamp] = None,
    taskStatistics: Option[zio.aws.iot.model.TaskStatistics] = None,
    scheduledAuditName: Option[ScheduledAuditName] = None,
    auditDetails: Option[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckDetails]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse = {
    import DescribeAuditTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse
      .builder()
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(taskType.map(value => value.unwrap))(_.taskType)
      .optionallyWith(
        taskStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(taskStatistics.map(value => value.buildAwsValue()))(
        _.taskStatistics
      )
      .optionallyWith(
        scheduledAuditName.map(value =>
          ScheduledAuditName.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditName)
      .optionallyWith(
        auditDetails.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.auditDetails)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly =
    zio.aws.iot.model.DescribeAuditTaskResponse.wrap(buildAwsValue())
}
object DescribeAuditTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuditTaskResponse =
      zio.aws.iot.model.DescribeAuditTaskResponse(
        taskStatus.map(value => value),
        taskType.map(value => value),
        taskStartTime.map(value => value),
        taskStatistics.map(value => value.asEditable),
        scheduledAuditName.map(value => value),
        auditDetails.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def taskStatus: Option[zio.aws.iot.model.AuditTaskStatus]
    def taskType: Option[zio.aws.iot.model.AuditTaskType]
    def taskStartTime: Option[Timestamp]
    def taskStatistics: Option[zio.aws.iot.model.TaskStatistics.ReadOnly]
    def scheduledAuditName: Option[ScheduledAuditName]
    def auditDetails: Option[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckDetails.ReadOnly]
    ]
    def getTaskStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskStatus] =
      AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getTaskType: ZIO[Any, AwsError, zio.aws.iot.model.AuditTaskType] =
      AwsError.unwrapOptionField("taskType", taskType)
    def getTaskStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getTaskStatistics
        : ZIO[Any, AwsError, zio.aws.iot.model.TaskStatistics.ReadOnly] =
      AwsError.unwrapOptionField("taskStatistics", taskStatistics)
    def getScheduledAuditName: ZIO[Any, AwsError, ScheduledAuditName] =
      AwsError.unwrapOptionField("scheduledAuditName", scheduledAuditName)
    def getAuditDetails: ZIO[Any, AwsError, Map[
      AuditCheckName,
      zio.aws.iot.model.AuditCheckDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("auditDetails", auditDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse
  ) extends zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly {
    override val taskStatus: Option[zio.aws.iot.model.AuditTaskStatus] = scala
      .Option(impl.taskStatus())
      .map(value => zio.aws.iot.model.AuditTaskStatus.wrap(value))
    override val taskType: Option[zio.aws.iot.model.AuditTaskType] = scala
      .Option(impl.taskType())
      .map(value => zio.aws.iot.model.AuditTaskType.wrap(value))
    override val taskStartTime: Option[Timestamp] = scala
      .Option(impl.taskStartTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val taskStatistics
        : Option[zio.aws.iot.model.TaskStatistics.ReadOnly] = scala
      .Option(impl.taskStatistics())
      .map(value => zio.aws.iot.model.TaskStatistics.wrap(value))
    override val scheduledAuditName: Option[ScheduledAuditName] = scala
      .Option(impl.scheduledAuditName())
      .map(value => zio.aws.iot.model.primitives.ScheduledAuditName(value))
    override val auditDetails: Option[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckDetails.ReadOnly]
    ] = scala
      .Option(impl.auditDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.AuditCheckName(
              key
            ) -> zio.aws.iot.model.AuditCheckDetails.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse
  ): zio.aws.iot.model.DescribeAuditTaskResponse.ReadOnly = new Wrapper(impl)
}
