package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAuthorizerResponse(
    authorizerDescription: Option[zio.aws.iot.model.AuthorizerDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse = {
    import DescribeAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse
      .builder()
      .optionallyWith(
        authorizerDescription.map(value => value.buildAwsValue())
      )(_.authorizerDescription)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeAuthorizerResponse.ReadOnly =
    zio.aws.iot.model.DescribeAuthorizerResponse.wrap(buildAwsValue())
}
object DescribeAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeAuthorizerResponse =
      zio.aws.iot.model.DescribeAuthorizerResponse(
        authorizerDescription.map(value => value.asEditable)
      )
    def authorizerDescription
        : Option[zio.aws.iot.model.AuthorizerDescription.ReadOnly]
    def getAuthorizerDescription
        : ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerDescription.ReadOnly] =
      AwsError.unwrapOptionField("authorizerDescription", authorizerDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse
  ) extends zio.aws.iot.model.DescribeAuthorizerResponse.ReadOnly {
    override val authorizerDescription
        : Option[zio.aws.iot.model.AuthorizerDescription.ReadOnly] = scala
      .Option(impl.authorizerDescription())
      .map(value => zio.aws.iot.model.AuthorizerDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse
  ): zio.aws.iot.model.DescribeAuthorizerResponse.ReadOnly = new Wrapper(impl)
}
