package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Version,
  BillingGroupArn,
  BillingGroupId,
  BillingGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeBillingGroupResponse(
    billingGroupName: Option[BillingGroupName] = None,
    billingGroupId: Option[BillingGroupId] = None,
    billingGroupArn: Option[BillingGroupArn] = None,
    version: Option[Version] = None,
    billingGroupProperties: Option[zio.aws.iot.model.BillingGroupProperties] =
      None,
    billingGroupMetadata: Option[zio.aws.iot.model.BillingGroupMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse = {
    import DescribeBillingGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse
      .builder()
      .optionallyWith(
        billingGroupName.map(value =>
          BillingGroupName.unwrap(value): java.lang.String
        )
      )(_.billingGroupName)
      .optionallyWith(
        billingGroupId.map(value =>
          BillingGroupId.unwrap(value): java.lang.String
        )
      )(_.billingGroupId)
      .optionallyWith(
        billingGroupArn.map(value =>
          BillingGroupArn.unwrap(value): java.lang.String
        )
      )(_.billingGroupArn)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        billingGroupProperties.map(value => value.buildAwsValue())
      )(_.billingGroupProperties)
      .optionallyWith(billingGroupMetadata.map(value => value.buildAwsValue()))(
        _.billingGroupMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly =
    zio.aws.iot.model.DescribeBillingGroupResponse.wrap(buildAwsValue())
}
object DescribeBillingGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeBillingGroupResponse =
      zio.aws.iot.model.DescribeBillingGroupResponse(
        billingGroupName.map(value => value),
        billingGroupId.map(value => value),
        billingGroupArn.map(value => value),
        version.map(value => value),
        billingGroupProperties.map(value => value.asEditable),
        billingGroupMetadata.map(value => value.asEditable)
      )
    def billingGroupName: Option[BillingGroupName]
    def billingGroupId: Option[BillingGroupId]
    def billingGroupArn: Option[BillingGroupArn]
    def version: Option[Version]
    def billingGroupProperties
        : Option[zio.aws.iot.model.BillingGroupProperties.ReadOnly]
    def billingGroupMetadata
        : Option[zio.aws.iot.model.BillingGroupMetadata.ReadOnly]
    def getBillingGroupName: ZIO[Any, AwsError, BillingGroupName] =
      AwsError.unwrapOptionField("billingGroupName", billingGroupName)
    def getBillingGroupId: ZIO[Any, AwsError, BillingGroupId] =
      AwsError.unwrapOptionField("billingGroupId", billingGroupId)
    def getBillingGroupArn: ZIO[Any, AwsError, BillingGroupArn] =
      AwsError.unwrapOptionField("billingGroupArn", billingGroupArn)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getBillingGroupProperties: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.BillingGroupProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "billingGroupProperties",
      billingGroupProperties
    )
    def getBillingGroupMetadata
        : ZIO[Any, AwsError, zio.aws.iot.model.BillingGroupMetadata.ReadOnly] =
      AwsError.unwrapOptionField("billingGroupMetadata", billingGroupMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse
  ) extends zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly {
    override val billingGroupName: Option[BillingGroupName] = scala
      .Option(impl.billingGroupName())
      .map(value => zio.aws.iot.model.primitives.BillingGroupName(value))
    override val billingGroupId: Option[BillingGroupId] = scala
      .Option(impl.billingGroupId())
      .map(value => zio.aws.iot.model.primitives.BillingGroupId(value))
    override val billingGroupArn: Option[BillingGroupArn] = scala
      .Option(impl.billingGroupArn())
      .map(value => zio.aws.iot.model.primitives.BillingGroupArn(value))
    override val version: Option[Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
    override val billingGroupProperties
        : Option[zio.aws.iot.model.BillingGroupProperties.ReadOnly] = scala
      .Option(impl.billingGroupProperties())
      .map(value => zio.aws.iot.model.BillingGroupProperties.wrap(value))
    override val billingGroupMetadata
        : Option[zio.aws.iot.model.BillingGroupMetadata.ReadOnly] = scala
      .Option(impl.billingGroupMetadata())
      .map(value => zio.aws.iot.model.BillingGroupMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse
  ): zio.aws.iot.model.DescribeBillingGroupResponse.ReadOnly = new Wrapper(impl)
}
