package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDetectMitigationActionsTaskResponse(
    taskSummary: Option[zio.aws.iot.model.DetectMitigationActionsTaskSummary] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse = {
    import DescribeDetectMitigationActionsTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse
      .builder()
      .optionallyWith(taskSummary.map(value => value.buildAwsValue()))(
        _.taskSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly =
    zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse
      .wrap(buildAwsValue())
}
object DescribeDetectMitigationActionsTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse =
      zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse(
        taskSummary.map(value => value.asEditable)
      )
    def taskSummary
        : Option[zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly]
    def getTaskSummary: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
    ] = AwsError.unwrapOptionField("taskSummary", taskSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse
  ) extends zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly {
    override val taskSummary: Option[
      zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly
    ] = scala
      .Option(impl.taskSummary())
      .map(value =>
        zio.aws.iot.model.DetectMitigationActionsTaskSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse
  ): zio.aws.iot.model.DescribeDetectMitigationActionsTaskResponse.ReadOnly =
    new Wrapper(impl)
}
