package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DateType,
  DomainName,
  DomainConfigurationArn,
  ReservedDomainConfigurationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeDomainConfigurationResponse(
    domainConfigurationName: Option[ReservedDomainConfigurationName] = None,
    domainConfigurationArn: Option[DomainConfigurationArn] = None,
    domainName: Option[DomainName] = None,
    serverCertificates: Option[
      Iterable[zio.aws.iot.model.ServerCertificateSummary]
    ] = None,
    authorizerConfig: Option[zio.aws.iot.model.AuthorizerConfig] = None,
    domainConfigurationStatus: Option[
      zio.aws.iot.model.DomainConfigurationStatus
    ] = None,
    serviceType: Option[zio.aws.iot.model.ServiceType] = None,
    domainType: Option[zio.aws.iot.model.DomainType] = None,
    lastStatusChangeDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse = {
    import DescribeDomainConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse
      .builder()
      .optionallyWith(
        domainConfigurationName.map(value =>
          ReservedDomainConfigurationName.unwrap(value): java.lang.String
        )
      )(_.domainConfigurationName)
      .optionallyWith(
        domainConfigurationArn.map(value =>
          DomainConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.domainConfigurationArn)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        serverCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverCertificates)
      .optionallyWith(authorizerConfig.map(value => value.buildAwsValue()))(
        _.authorizerConfig
      )
      .optionallyWith(domainConfigurationStatus.map(value => value.unwrap))(
        _.domainConfigurationStatus
      )
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .optionallyWith(domainType.map(value => value.unwrap))(_.domainType)
      .optionallyWith(
        lastStatusChangeDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastStatusChangeDate)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeDomainConfigurationResponse.ReadOnly =
    zio.aws.iot.model.DescribeDomainConfigurationResponse.wrap(buildAwsValue())
}
object DescribeDomainConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeDomainConfigurationResponse =
      zio.aws.iot.model.DescribeDomainConfigurationResponse(
        domainConfigurationName.map(value => value),
        domainConfigurationArn.map(value => value),
        domainName.map(value => value),
        serverCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        authorizerConfig.map(value => value.asEditable),
        domainConfigurationStatus.map(value => value),
        serviceType.map(value => value),
        domainType.map(value => value),
        lastStatusChangeDate.map(value => value)
      )
    def domainConfigurationName: Option[ReservedDomainConfigurationName]
    def domainConfigurationArn: Option[DomainConfigurationArn]
    def domainName: Option[DomainName]
    def serverCertificates
        : Option[List[zio.aws.iot.model.ServerCertificateSummary.ReadOnly]]
    def authorizerConfig: Option[zio.aws.iot.model.AuthorizerConfig.ReadOnly]
    def domainConfigurationStatus
        : Option[zio.aws.iot.model.DomainConfigurationStatus]
    def serviceType: Option[zio.aws.iot.model.ServiceType]
    def domainType: Option[zio.aws.iot.model.DomainType]
    def lastStatusChangeDate: Option[DateType]
    def getDomainConfigurationName
        : ZIO[Any, AwsError, ReservedDomainConfigurationName] = AwsError
      .unwrapOptionField("domainConfigurationName", domainConfigurationName)
    def getDomainConfigurationArn: ZIO[Any, AwsError, DomainConfigurationArn] =
      AwsError.unwrapOptionField(
        "domainConfigurationArn",
        domainConfigurationArn
      )
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getServerCertificates: ZIO[Any, AwsError, List[
      zio.aws.iot.model.ServerCertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("serverCertificates", serverCertificates)
    def getAuthorizerConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerConfig.ReadOnly] =
      AwsError.unwrapOptionField("authorizerConfig", authorizerConfig)
    def getDomainConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.DomainConfigurationStatus] =
      AwsError.unwrapOptionField(
        "domainConfigurationStatus",
        domainConfigurationStatus
      )
    def getServiceType: ZIO[Any, AwsError, zio.aws.iot.model.ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
    def getDomainType: ZIO[Any, AwsError, zio.aws.iot.model.DomainType] =
      AwsError.unwrapOptionField("domainType", domainType)
    def getLastStatusChangeDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastStatusChangeDate", lastStatusChangeDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse
  ) extends zio.aws.iot.model.DescribeDomainConfigurationResponse.ReadOnly {
    override val domainConfigurationName
        : Option[ReservedDomainConfigurationName] = scala
      .Option(impl.domainConfigurationName())
      .map(value =>
        zio.aws.iot.model.primitives.ReservedDomainConfigurationName(value)
      )
    override val domainConfigurationArn: Option[DomainConfigurationArn] = scala
      .Option(impl.domainConfigurationArn())
      .map(value => zio.aws.iot.model.primitives.DomainConfigurationArn(value))
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.iot.model.primitives.DomainName(value))
    override val serverCertificates
        : Option[List[zio.aws.iot.model.ServerCertificateSummary.ReadOnly]] =
      scala
        .Option(impl.serverCertificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ServerCertificateSummary.wrap(item)
          }.toList
        )
    override val authorizerConfig
        : Option[zio.aws.iot.model.AuthorizerConfig.ReadOnly] = scala
      .Option(impl.authorizerConfig())
      .map(value => zio.aws.iot.model.AuthorizerConfig.wrap(value))
    override val domainConfigurationStatus
        : Option[zio.aws.iot.model.DomainConfigurationStatus] = scala
      .Option(impl.domainConfigurationStatus())
      .map(value => zio.aws.iot.model.DomainConfigurationStatus.wrap(value))
    override val serviceType: Option[zio.aws.iot.model.ServiceType] = scala
      .Option(impl.serviceType())
      .map(value => zio.aws.iot.model.ServiceType.wrap(value))
    override val domainType: Option[zio.aws.iot.model.DomainType] = scala
      .Option(impl.domainType())
      .map(value => zio.aws.iot.model.DomainType.wrap(value))
    override val lastStatusChangeDate: Option[DateType] = scala
      .Option(impl.lastStatusChangeDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse
  ): zio.aws.iot.model.DescribeDomainConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
