package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.EndpointType
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointRequest(
    endpointType: Option[EndpointType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeEndpointRequest = {
    import DescribeEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeEndpointRequest
      .builder()
      .optionallyWith(
        endpointType.map(value => EndpointType.unwrap(value): java.lang.String)
      )(_.endpointType)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeEndpointRequest.ReadOnly =
    zio.aws.iot.model.DescribeEndpointRequest.wrap(buildAwsValue())
}
object DescribeEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeEndpointRequest =
      zio.aws.iot.model
        .DescribeEndpointRequest(endpointType.map(value => value))
    def endpointType: Option[EndpointType]
    def getEndpointType: ZIO[Any, AwsError, EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeEndpointRequest
  ) extends zio.aws.iot.model.DescribeEndpointRequest.ReadOnly {
    override val endpointType: Option[EndpointType] = scala
      .Option(impl.endpointType())
      .map(value => zio.aws.iot.model.primitives.EndpointType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeEndpointRequest
  ): zio.aws.iot.model.DescribeEndpointRequest.ReadOnly = new Wrapper(impl)
}
