package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.IndexName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeIndexRequest(indexName: IndexName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeIndexRequest = {
    import DescribeIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeIndexRequest
      .builder()
      .indexName(IndexName.unwrap(indexName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeIndexRequest.ReadOnly =
    zio.aws.iot.model.DescribeIndexRequest.wrap(buildAwsValue())
}
object DescribeIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeIndexRequest =
      zio.aws.iot.model.DescribeIndexRequest(indexName)
    def indexName: IndexName
    def getIndexName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(indexName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeIndexRequest
  ) extends zio.aws.iot.model.DescribeIndexRequest.ReadOnly {
    override val indexName: IndexName =
      zio.aws.iot.model.primitives.IndexName(impl.indexName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeIndexRequest
  ): zio.aws.iot.model.DescribeIndexRequest.ReadOnly = new Wrapper(impl)
}
