package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ExecutionNumber, ThingName, JobId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeJobExecutionRequest(
    jobId: JobId,
    thingName: ThingName,
    executionNumber: Option[ExecutionNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest = {
    import DescribeJobExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeJobExecutionRequest.ReadOnly =
    zio.aws.iot.model.DescribeJobExecutionRequest.wrap(buildAwsValue())
}
object DescribeJobExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeJobExecutionRequest =
      zio.aws.iot.model.DescribeJobExecutionRequest(
        jobId,
        thingName,
        executionNumber.map(value => value)
      )
    def jobId: JobId
    def thingName: ThingName
    def executionNumber: Option[ExecutionNumber]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest
  ) extends zio.aws.iot.model.DescribeJobExecutionRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val executionNumber: Option[ExecutionNumber] = scala
      .Option(impl.executionNumber())
      .map(value => zio.aws.iot.model.primitives.ExecutionNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest
  ): zio.aws.iot.model.DescribeJobExecutionRequest.ReadOnly = new Wrapper(impl)
}
