package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeJobExecutionResponse(
    execution: Option[zio.aws.iot.model.JobExecution] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse = {
    import DescribeJobExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse
      .builder()
      .optionallyWith(execution.map(value => value.buildAwsValue()))(
        _.execution
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeJobExecutionResponse.ReadOnly =
    zio.aws.iot.model.DescribeJobExecutionResponse.wrap(buildAwsValue())
}
object DescribeJobExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeJobExecutionResponse =
      zio.aws.iot.model
        .DescribeJobExecutionResponse(execution.map(value => value.asEditable))
    def execution: Option[zio.aws.iot.model.JobExecution.ReadOnly]
    def getExecution
        : ZIO[Any, AwsError, zio.aws.iot.model.JobExecution.ReadOnly] =
      AwsError.unwrapOptionField("execution", execution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse
  ) extends zio.aws.iot.model.DescribeJobExecutionResponse.ReadOnly {
    override val execution: Option[zio.aws.iot.model.JobExecution.ReadOnly] =
      scala
        .Option(impl.execution())
        .map(value => zio.aws.iot.model.JobExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse
  ): zio.aws.iot.model.DescribeJobExecutionResponse.ReadOnly = new Wrapper(impl)
}
