package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeJobRequest = {
    import DescribeJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeJobRequest.ReadOnly =
    zio.aws.iot.model.DescribeJobRequest.wrap(buildAwsValue())
}
object DescribeJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeJobRequest =
      zio.aws.iot.model.DescribeJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobRequest
  ) extends zio.aws.iot.model.DescribeJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeJobRequest
  ): zio.aws.iot.model.DescribeJobRequest.ReadOnly = new Wrapper(impl)
}
