package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ManagedTemplateVersion,
  ManagedJobTemplateName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeManagedJobTemplateRequest(
    templateName: ManagedJobTemplateName,
    templateVersion: Option[ManagedTemplateVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest = {
    import DescribeManagedJobTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest
      .builder()
      .templateName(
        ManagedJobTemplateName.unwrap(templateName): java.lang.String
      )
      .optionallyWith(
        templateVersion.map(value =>
          ManagedTemplateVersion.unwrap(value): java.lang.String
        )
      )(_.templateVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DescribeManagedJobTemplateRequest.ReadOnly =
    zio.aws.iot.model.DescribeManagedJobTemplateRequest.wrap(buildAwsValue())
}
object DescribeManagedJobTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeManagedJobTemplateRequest =
      zio.aws.iot.model.DescribeManagedJobTemplateRequest(
        templateName,
        templateVersion.map(value => value)
      )
    def templateName: ManagedJobTemplateName
    def templateVersion: Option[ManagedTemplateVersion]
    def getTemplateName: ZIO[Any, Nothing, ManagedJobTemplateName] =
      ZIO.succeed(templateName)
    def getTemplateVersion: ZIO[Any, AwsError, ManagedTemplateVersion] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest
  ) extends zio.aws.iot.model.DescribeManagedJobTemplateRequest.ReadOnly {
    override val templateName: ManagedJobTemplateName =
      zio.aws.iot.model.primitives.ManagedJobTemplateName(impl.templateName())
    override val templateVersion: Option[ManagedTemplateVersion] = scala
      .Option(impl.templateVersion())
      .map(value => zio.aws.iot.model.primitives.ManagedTemplateVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest
  ): zio.aws.iot.model.DescribeManagedJobTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
