package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RegistryS3KeyName,
  ErrorMessage,
  RoleArn,
  Percentage,
  RegistryS3BucketName,
  Count,
  TemplateBody,
  LastModifiedDate,
  TaskId,
  CreationDate
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeThingRegistrationTaskResponse(
    taskId: Option[TaskId] = None,
    creationDate: Option[CreationDate] = None,
    lastModifiedDate: Option[LastModifiedDate] = None,
    templateBody: Option[TemplateBody] = None,
    inputFileBucket: Option[RegistryS3BucketName] = None,
    inputFileKey: Option[RegistryS3KeyName] = None,
    roleArn: Option[RoleArn] = None,
    status: Option[zio.aws.iot.model.Status] = None,
    message: Option[ErrorMessage] = None,
    successCount: Option[Count] = None,
    failureCount: Option[Count] = None,
    percentageProgress: Option[Percentage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse = {
    import DescribeThingRegistrationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse
      .builder()
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        inputFileBucket.map(value =>
          RegistryS3BucketName.unwrap(value): java.lang.String
        )
      )(_.inputFileBucket)
      .optionallyWith(
        inputFileKey.map(value =>
          RegistryS3KeyName.unwrap(value): java.lang.String
        )
      )(_.inputFileKey)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(successCount.map(value => Count.unwrap(value): Integer))(
        _.successCount
      )
      .optionallyWith(failureCount.map(value => Count.unwrap(value): Integer))(
        _.failureCount
      )
      .optionallyWith(
        percentageProgress.map(value => Percentage.unwrap(value): Integer)
      )(_.percentageProgress)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly =
    zio.aws.iot.model.DescribeThingRegistrationTaskResponse
      .wrap(buildAwsValue())
}
object DescribeThingRegistrationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DescribeThingRegistrationTaskResponse =
      zio.aws.iot.model.DescribeThingRegistrationTaskResponse(
        taskId.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        templateBody.map(value => value),
        inputFileBucket.map(value => value),
        inputFileKey.map(value => value),
        roleArn.map(value => value),
        status.map(value => value),
        message.map(value => value),
        successCount.map(value => value),
        failureCount.map(value => value),
        percentageProgress.map(value => value)
      )
    def taskId: Option[TaskId]
    def creationDate: Option[CreationDate]
    def lastModifiedDate: Option[LastModifiedDate]
    def templateBody: Option[TemplateBody]
    def inputFileBucket: Option[RegistryS3BucketName]
    def inputFileKey: Option[RegistryS3KeyName]
    def roleArn: Option[RoleArn]
    def status: Option[zio.aws.iot.model.Status]
    def message: Option[ErrorMessage]
    def successCount: Option[Count]
    def failureCount: Option[Count]
    def percentageProgress: Option[Percentage]
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getInputFileBucket: ZIO[Any, AwsError, RegistryS3BucketName] =
      AwsError.unwrapOptionField("inputFileBucket", inputFileBucket)
    def getInputFileKey: ZIO[Any, AwsError, RegistryS3KeyName] =
      AwsError.unwrapOptionField("inputFileKey", inputFileKey)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getSuccessCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("successCount", successCount)
    def getFailureCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("failureCount", failureCount)
    def getPercentageProgress: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentageProgress", percentageProgress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse
  ) extends zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly {
    override val taskId: Option[TaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.TaskId(value))
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.CreationDate(value))
    override val lastModifiedDate: Option[LastModifiedDate] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.LastModifiedDate(value))
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.iot.model.primitives.TemplateBody(value))
    override val inputFileBucket: Option[RegistryS3BucketName] = scala
      .Option(impl.inputFileBucket())
      .map(value => zio.aws.iot.model.primitives.RegistryS3BucketName(value))
    override val inputFileKey: Option[RegistryS3KeyName] = scala
      .Option(impl.inputFileKey())
      .map(value => zio.aws.iot.model.primitives.RegistryS3KeyName(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val status: Option[zio.aws.iot.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.Status.wrap(value))
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
    override val successCount: Option[Count] = scala
      .Option(impl.successCount())
      .map(value => zio.aws.iot.model.primitives.Count(value))
    override val failureCount: Option[Count] = scala
      .Option(impl.failureCount())
      .map(value => zio.aws.iot.model.primitives.Count(value))
    override val percentageProgress: Option[Percentage] = scala
      .Option(impl.percentageProgress())
      .map(value => zio.aws.iot.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse
  ): zio.aws.iot.model.DescribeThingRegistrationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
