package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  SecurityProfileTargetArn,
  SecurityProfileName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetachSecurityProfileRequest(
    securityProfileName: SecurityProfileName,
    securityProfileTargetArn: SecurityProfileTargetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest = {
    import DetachSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest
      .builder()
      .securityProfileName(
        SecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .securityProfileTargetArn(
        SecurityProfileTargetArn.unwrap(
          securityProfileTargetArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DetachSecurityProfileRequest.ReadOnly =
    zio.aws.iot.model.DetachSecurityProfileRequest.wrap(buildAwsValue())
}
object DetachSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetachSecurityProfileRequest =
      zio.aws.iot.model.DetachSecurityProfileRequest(
        securityProfileName,
        securityProfileTargetArn
      )
    def securityProfileName: SecurityProfileName
    def securityProfileTargetArn: SecurityProfileTargetArn
    def getSecurityProfileName: ZIO[Any, Nothing, SecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getSecurityProfileTargetArn
        : ZIO[Any, Nothing, SecurityProfileTargetArn] =
      ZIO.succeed(securityProfileTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest
  ) extends zio.aws.iot.model.DetachSecurityProfileRequest.ReadOnly {
    override val securityProfileName: SecurityProfileName =
      zio.aws.iot.model.primitives
        .SecurityProfileName(impl.securityProfileName())
    override val securityProfileTargetArn: SecurityProfileTargetArn =
      zio.aws.iot.model.primitives
        .SecurityProfileTargetArn(impl.securityProfileTargetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest
  ): zio.aws.iot.model.DetachSecurityProfileRequest.ReadOnly = new Wrapper(impl)
}
