package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DeviceDefenderThingName,
  ErrorMessage,
  ViolationId,
  Timestamp,
  DetectMitigationActionExecutionErrorCode,
  MitigationActionsTaskId,
  MitigationActionName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DetectMitigationActionExecution(
    taskId: Option[MitigationActionsTaskId] = None,
    violationId: Option[ViolationId] = None,
    actionName: Option[MitigationActionName] = None,
    thingName: Option[DeviceDefenderThingName] = None,
    executionStartDate: Option[Timestamp] = None,
    executionEndDate: Option[Timestamp] = None,
    status: Option[zio.aws.iot.model.DetectMitigationActionExecutionStatus] =
      None,
    errorCode: Option[DetectMitigationActionExecutionErrorCode] = None,
    message: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution = {
    import DetectMitigationActionExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(
        violationId.map(value => ViolationId.unwrap(value): java.lang.String)
      )(_.violationId)
      .optionallyWith(
        actionName.map(value =>
          MitigationActionName.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(
        thingName.map(value =>
          DeviceDefenderThingName.unwrap(value): java.lang.String
        )
      )(_.thingName)
      .optionallyWith(
        executionStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.executionStartDate)
      .optionallyWith(
        executionEndDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.executionEndDate)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errorCode.map(value =>
          DetectMitigationActionExecutionErrorCode.unwrap(
            value
          ): java.lang.String
        )
      )(_.errorCode)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly =
    zio.aws.iot.model.DetectMitigationActionExecution.wrap(buildAwsValue())
}
object DetectMitigationActionExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetectMitigationActionExecution =
      zio.aws.iot.model.DetectMitigationActionExecution(
        taskId.map(value => value),
        violationId.map(value => value),
        actionName.map(value => value),
        thingName.map(value => value),
        executionStartDate.map(value => value),
        executionEndDate.map(value => value),
        status.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def taskId: Option[MitigationActionsTaskId]
    def violationId: Option[ViolationId]
    def actionName: Option[MitigationActionName]
    def thingName: Option[DeviceDefenderThingName]
    def executionStartDate: Option[Timestamp]
    def executionEndDate: Option[Timestamp]
    def status: Option[zio.aws.iot.model.DetectMitigationActionExecutionStatus]
    def errorCode: Option[DetectMitigationActionExecutionErrorCode]
    def message: Option[ErrorMessage]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getViolationId: ZIO[Any, AwsError, ViolationId] =
      AwsError.unwrapOptionField("violationId", violationId)
    def getActionName: ZIO[Any, AwsError, MitigationActionName] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getThingName: ZIO[Any, AwsError, DeviceDefenderThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getExecutionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executionStartDate", executionStartDate)
    def getExecutionEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executionEndDate", executionEndDate)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getErrorCode
        : ZIO[Any, AwsError, DetectMitigationActionExecutionErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution
  ) extends zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly {
    override val taskId: Option[MitigationActionsTaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionsTaskId(value))
    override val violationId: Option[ViolationId] = scala
      .Option(impl.violationId())
      .map(value => zio.aws.iot.model.primitives.ViolationId(value))
    override val actionName: Option[MitigationActionName] = scala
      .Option(impl.actionName())
      .map(value => zio.aws.iot.model.primitives.MitigationActionName(value))
    override val thingName: Option[DeviceDefenderThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.DeviceDefenderThingName(value))
    override val executionStartDate: Option[Timestamp] = scala
      .Option(impl.executionStartDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val executionEndDate: Option[Timestamp] = scala
      .Option(impl.executionEndDate())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val status
        : Option[zio.aws.iot.model.DetectMitigationActionExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.iot.model.DetectMitigationActionExecutionStatus.wrap(value)
        )
    override val errorCode: Option[DetectMitigationActionExecutionErrorCode] =
      scala
        .Option(impl.errorCode())
        .map(value =>
          zio.aws.iot.model.primitives
            .DetectMitigationActionExecutionErrorCode(value)
        )
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.iot.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution
  ): zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly = new Wrapper(
    impl
  )
}
