package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  PrimitiveBoolean,
  Timestamp,
  MitigationActionsTaskId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DetectMitigationActionsTaskSummary(
    taskId: Option[MitigationActionsTaskId] = None,
    taskStatus: Option[zio.aws.iot.model.DetectMitigationActionsTaskStatus] =
      None,
    taskStartTime: Option[Timestamp] = None,
    taskEndTime: Option[Timestamp] = None,
    target: Option[zio.aws.iot.model.DetectMitigationActionsTaskTarget] = None,
    violationEventOccurrenceRange: Option[
      zio.aws.iot.model.ViolationEventOccurrenceRange
    ] = None,
    onlyActiveViolationsIncluded: Option[PrimitiveBoolean] = None,
    suppressedAlertsIncluded: Option[PrimitiveBoolean] = None,
    actionsDefinition: Option[Iterable[zio.aws.iot.model.MitigationAction]] =
      None,
    taskStatistics: Option[
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary = {
    import DetectMitigationActionsTaskSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .optionallyWith(taskStatus.map(value => value.unwrap))(_.taskStatus)
      .optionallyWith(
        taskStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskStartTime)
      .optionallyWith(
        taskEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.taskEndTime)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .optionallyWith(
        violationEventOccurrenceRange.map(value => value.buildAwsValue())
      )(_.violationEventOccurrenceRange)
      .optionallyWith(
        onlyActiveViolationsIncluded.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.onlyActiveViolationsIncluded)
      .optionallyWith(
        suppressedAlertsIncluded.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.suppressedAlertsIncluded)
      .optionallyWith(
        actionsDefinition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionsDefinition)
      .optionallyWith(taskStatistics.map(value => value.buildAwsValue()))(
        _.taskStatistics
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly =
    zio.aws.iot.model.DetectMitigationActionsTaskSummary.wrap(buildAwsValue())
}
object DetectMitigationActionsTaskSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DetectMitigationActionsTaskSummary =
      zio.aws.iot.model.DetectMitigationActionsTaskSummary(
        taskId.map(value => value),
        taskStatus.map(value => value),
        taskStartTime.map(value => value),
        taskEndTime.map(value => value),
        target.map(value => value.asEditable),
        violationEventOccurrenceRange.map(value => value.asEditable),
        onlyActiveViolationsIncluded.map(value => value),
        suppressedAlertsIncluded.map(value => value),
        actionsDefinition.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskStatistics.map(value => value.asEditable)
      )
    def taskId: Option[MitigationActionsTaskId]
    def taskStatus: Option[zio.aws.iot.model.DetectMitigationActionsTaskStatus]
    def taskStartTime: Option[Timestamp]
    def taskEndTime: Option[Timestamp]
    def target
        : Option[zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly]
    def violationEventOccurrenceRange
        : Option[zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly]
    def onlyActiveViolationsIncluded: Option[PrimitiveBoolean]
    def suppressedAlertsIncluded: Option[PrimitiveBoolean]
    def actionsDefinition
        : Option[List[zio.aws.iot.model.MitigationAction.ReadOnly]]
    def taskStatistics: Option[
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly
    ]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getTaskStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskStatus
    ] = AwsError.unwrapOptionField("taskStatus", taskStatus)
    def getTaskStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskStartTime", taskStartTime)
    def getTaskEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("taskEndTime", taskEndTime)
    def getTarget: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly
    ] = AwsError.unwrapOptionField("target", target)
    def getViolationEventOccurrenceRange: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "violationEventOccurrenceRange",
      violationEventOccurrenceRange
    )
    def getOnlyActiveViolationsIncluded: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField(
        "onlyActiveViolationsIncluded",
        onlyActiveViolationsIncluded
      )
    def getSuppressedAlertsIncluded: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField(
        "suppressedAlertsIncluded",
        suppressedAlertsIncluded
      )
    def getActionsDefinition: ZIO[Any, AwsError, List[
      zio.aws.iot.model.MitigationAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actionsDefinition", actionsDefinition)
    def getTaskStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("taskStatistics", taskStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary
  ) extends zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly {
    override val taskId: Option[MitigationActionsTaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.MitigationActionsTaskId(value))
    override val taskStatus
        : Option[zio.aws.iot.model.DetectMitigationActionsTaskStatus] = scala
      .Option(impl.taskStatus())
      .map(value =>
        zio.aws.iot.model.DetectMitigationActionsTaskStatus.wrap(value)
      )
    override val taskStartTime: Option[Timestamp] = scala
      .Option(impl.taskStartTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val taskEndTime: Option[Timestamp] = scala
      .Option(impl.taskEndTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val target
        : Option[zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly] =
      scala
        .Option(impl.target())
        .map(value =>
          zio.aws.iot.model.DetectMitigationActionsTaskTarget.wrap(value)
        )
    override val violationEventOccurrenceRange
        : Option[zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly] =
      scala
        .Option(impl.violationEventOccurrenceRange())
        .map(value =>
          zio.aws.iot.model.ViolationEventOccurrenceRange.wrap(value)
        )
    override val onlyActiveViolationsIncluded: Option[PrimitiveBoolean] = scala
      .Option(impl.onlyActiveViolationsIncluded())
      .map(value => zio.aws.iot.model.primitives.PrimitiveBoolean(value))
    override val suppressedAlertsIncluded: Option[PrimitiveBoolean] = scala
      .Option(impl.suppressedAlertsIncluded())
      .map(value => zio.aws.iot.model.primitives.PrimitiveBoolean(value))
    override val actionsDefinition
        : Option[List[zio.aws.iot.model.MitigationAction.ReadOnly]] = scala
      .Option(impl.actionsDefinition())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.MitigationAction.wrap(item)
        }.toList
      )
    override val taskStatistics: Option[
      zio.aws.iot.model.DetectMitigationActionsTaskStatistics.ReadOnly
    ] = scala
      .Option(impl.taskStatistics())
      .map(value =>
        zio.aws.iot.model.DetectMitigationActionsTaskStatistics.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DetectMitigationActionsTaskSummary
  ): zio.aws.iot.model.DetectMitigationActionsTaskSummary.ReadOnly =
    new Wrapper(impl)
}
