package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DomainConfigurationArn,
  ReservedDomainConfigurationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DomainConfigurationSummary(
    domainConfigurationName: Option[ReservedDomainConfigurationName] = None,
    domainConfigurationArn: Option[DomainConfigurationArn] = None,
    serviceType: Option[zio.aws.iot.model.ServiceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.DomainConfigurationSummary = {
    import DomainConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.DomainConfigurationSummary
      .builder()
      .optionallyWith(
        domainConfigurationName.map(value =>
          ReservedDomainConfigurationName.unwrap(value): java.lang.String
        )
      )(_.domainConfigurationName)
      .optionallyWith(
        domainConfigurationArn.map(value =>
          DomainConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.domainConfigurationArn)
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.DomainConfigurationSummary.ReadOnly =
    zio.aws.iot.model.DomainConfigurationSummary.wrap(buildAwsValue())
}
object DomainConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.DomainConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.DomainConfigurationSummary =
      zio.aws.iot.model.DomainConfigurationSummary(
        domainConfigurationName.map(value => value),
        domainConfigurationArn.map(value => value),
        serviceType.map(value => value)
      )
    def domainConfigurationName: Option[ReservedDomainConfigurationName]
    def domainConfigurationArn: Option[DomainConfigurationArn]
    def serviceType: Option[zio.aws.iot.model.ServiceType]
    def getDomainConfigurationName
        : ZIO[Any, AwsError, ReservedDomainConfigurationName] = AwsError
      .unwrapOptionField("domainConfigurationName", domainConfigurationName)
    def getDomainConfigurationArn: ZIO[Any, AwsError, DomainConfigurationArn] =
      AwsError.unwrapOptionField(
        "domainConfigurationArn",
        domainConfigurationArn
      )
    def getServiceType: ZIO[Any, AwsError, zio.aws.iot.model.ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.DomainConfigurationSummary
  ) extends zio.aws.iot.model.DomainConfigurationSummary.ReadOnly {
    override val domainConfigurationName
        : Option[ReservedDomainConfigurationName] = scala
      .Option(impl.domainConfigurationName())
      .map(value =>
        zio.aws.iot.model.primitives.ReservedDomainConfigurationName(value)
      )
    override val domainConfigurationArn: Option[DomainConfigurationArn] = scala
      .Option(impl.domainConfigurationArn())
      .map(value => zio.aws.iot.model.primitives.DomainConfigurationArn(value))
    override val serviceType: Option[zio.aws.iot.model.ServiceType] = scala
      .Option(impl.serviceType())
      .map(value => zio.aws.iot.model.ServiceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.DomainConfigurationSummary
  ): zio.aws.iot.model.DomainConfigurationSummary.ReadOnly = new Wrapper(impl)
}
