package zio.aws.iot.model
import scala.jdk.CollectionConverters.*
sealed trait DynamicGroupStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.DynamicGroupStatus
}
object DynamicGroupStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.DynamicGroupStatus
  ): zio.aws.iot.model.DynamicGroupStatus = value match {
    case software.amazon.awssdk.services.iot.model.DynamicGroupStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.DynamicGroupStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iot.model.DynamicGroupStatus.BUILDING =>
      val r = BUILDING
      r
    case software.amazon.awssdk.services.iot.model.DynamicGroupStatus.REBUILDING =>
      val r = REBUILDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.DynamicGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DynamicGroupStatus =
      software.amazon.awssdk.services.iot.model.DynamicGroupStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.iot.model.DynamicGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DynamicGroupStatus =
      software.amazon.awssdk.services.iot.model.DynamicGroupStatus.ACTIVE
  }
  case object BUILDING extends zio.aws.iot.model.DynamicGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DynamicGroupStatus =
      software.amazon.awssdk.services.iot.model.DynamicGroupStatus.BUILDING
  }
  case object REBUILDING extends zio.aws.iot.model.DynamicGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.DynamicGroupStatus =
      software.amazon.awssdk.services.iot.model.DynamicGroupStatus.REBUILDING
  }
}
