package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyDocument, PolicyArn, PolicyName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EffectivePolicy(
    policyName: Option[PolicyName] = None,
    policyArn: Option[PolicyArn] = None,
    policyDocument: Option[PolicyDocument] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.EffectivePolicy = {
    import EffectivePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.EffectivePolicy
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.EffectivePolicy.ReadOnly =
    zio.aws.iot.model.EffectivePolicy.wrap(buildAwsValue())
}
object EffectivePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.EffectivePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.EffectivePolicy =
      zio.aws.iot.model.EffectivePolicy(
        policyName.map(value => value),
        policyArn.map(value => value),
        policyDocument.map(value => value)
      )
    def policyName: Option[PolicyName]
    def policyArn: Option[PolicyArn]
    def policyDocument: Option[PolicyDocument]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.EffectivePolicy
  ) extends zio.aws.iot.model.EffectivePolicy.ReadOnly {
    override val policyName: Option[PolicyName] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyArn: Option[PolicyArn] = scala
      .Option(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
    override val policyDocument: Option[PolicyDocument] = scala
      .Option(impl.policyDocument())
      .map(value => zio.aws.iot.model.primitives.PolicyDocument(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.EffectivePolicy
  ): zio.aws.iot.model.EffectivePolicy.ReadOnly = new Wrapper(impl)
}
