package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{OTAUpdateErrorMessage, Code}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ErrorInfo(
    code: Option[Code] = None,
    message: Option[OTAUpdateErrorMessage] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.ErrorInfo = {
    import ErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ErrorInfo
      .builder()
      .optionallyWith(code.map(value => Code.unwrap(value): java.lang.String))(
        _.code
      )
      .optionallyWith(
        message.map(value =>
          OTAUpdateErrorMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ErrorInfo.ReadOnly =
    zio.aws.iot.model.ErrorInfo.wrap(buildAwsValue())
}
object ErrorInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.ErrorInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ErrorInfo = zio.aws.iot.model
      .ErrorInfo(code.map(value => value), message.map(value => value))
    def code: Option[Code]
    def message: Option[OTAUpdateErrorMessage]
    def getCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, OTAUpdateErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ErrorInfo
  ) extends zio.aws.iot.model.ErrorInfo.ReadOnly {
    override val code: Option[Code] = scala
      .Option(impl.code())
      .map(value => zio.aws.iot.model.primitives.Code(value))
    override val message: Option[OTAUpdateErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.iot.model.primitives.OTAUpdateErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ErrorInfo
  ): zio.aws.iot.model.ErrorInfo.ReadOnly = new Wrapper(impl)
}
