package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.Count
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketsAggregationResponse(
    totalCount: Option[Count] = None,
    buckets: Option[Iterable[zio.aws.iot.model.Bucket]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetBucketsAggregationResponse = {
    import GetBucketsAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetBucketsAggregationResponse
      .builder()
      .optionallyWith(totalCount.map(value => Count.unwrap(value): Integer))(
        _.totalCount
      )
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetBucketsAggregationResponse.ReadOnly =
    zio.aws.iot.model.GetBucketsAggregationResponse.wrap(buildAwsValue())
}
object GetBucketsAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetBucketsAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetBucketsAggregationResponse =
      zio.aws.iot.model.GetBucketsAggregationResponse(
        totalCount.map(value => value),
        buckets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def totalCount: Option[Count]
    def buckets: Option[List[zio.aws.iot.model.Bucket.ReadOnly]]
    def getTotalCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("totalCount", totalCount)
    def getBuckets
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Bucket.ReadOnly]] =
      AwsError.unwrapOptionField("buckets", buckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetBucketsAggregationResponse
  ) extends zio.aws.iot.model.GetBucketsAggregationResponse.ReadOnly {
    override val totalCount: Option[Count] = scala
      .Option(impl.totalCount())
      .map(value => zio.aws.iot.model.primitives.Count(value))
    override val buckets: Option[List[zio.aws.iot.model.Bucket.ReadOnly]] =
      scala
        .Option(impl.buckets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Bucket.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetBucketsAggregationResponse
  ): zio.aws.iot.model.GetBucketsAggregationResponse.ReadOnly = new Wrapper(
    impl
  )
}
