package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingName,
  CognitoIdentityPoolId,
  Principal
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetEffectivePoliciesRequest(
    principal: Option[Principal] = None,
    cognitoIdentityPoolId: Option[CognitoIdentityPoolId] = None,
    thingName: Option[ThingName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest = {
    import GetEffectivePoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest
      .builder()
      .optionallyWith(
        principal.map(value => Principal.unwrap(value): java.lang.String)
      )(_.principal)
      .optionallyWith(
        cognitoIdentityPoolId.map(value =>
          CognitoIdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.cognitoIdentityPoolId)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetEffectivePoliciesRequest.ReadOnly =
    zio.aws.iot.model.GetEffectivePoliciesRequest.wrap(buildAwsValue())
}
object GetEffectivePoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetEffectivePoliciesRequest =
      zio.aws.iot.model.GetEffectivePoliciesRequest(
        principal.map(value => value),
        cognitoIdentityPoolId.map(value => value),
        thingName.map(value => value)
      )
    def principal: Option[Principal]
    def cognitoIdentityPoolId: Option[CognitoIdentityPoolId]
    def thingName: Option[ThingName]
    def getPrincipal: ZIO[Any, AwsError, Principal] =
      AwsError.unwrapOptionField("principal", principal)
    def getCognitoIdentityPoolId: ZIO[Any, AwsError, CognitoIdentityPoolId] =
      AwsError.unwrapOptionField("cognitoIdentityPoolId", cognitoIdentityPoolId)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest
  ) extends zio.aws.iot.model.GetEffectivePoliciesRequest.ReadOnly {
    override val principal: Option[Principal] = scala
      .Option(impl.principal())
      .map(value => zio.aws.iot.model.primitives.Principal(value))
    override val cognitoIdentityPoolId: Option[CognitoIdentityPoolId] = scala
      .Option(impl.cognitoIdentityPoolId())
      .map(value => zio.aws.iot.model.primitives.CognitoIdentityPoolId(value))
    override val thingName: Option[ThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest
  ): zio.aws.iot.model.GetEffectivePoliciesRequest.ReadOnly = new Wrapper(impl)
}
