package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.JobDocument
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetJobDocumentResponse(document: Option[JobDocument] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetJobDocumentResponse = {
    import GetJobDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetJobDocumentResponse
      .builder()
      .optionallyWith(
        document.map(value => JobDocument.unwrap(value): java.lang.String)
      )(_.document)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetJobDocumentResponse.ReadOnly =
    zio.aws.iot.model.GetJobDocumentResponse.wrap(buildAwsValue())
}
object GetJobDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetJobDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetJobDocumentResponse =
      zio.aws.iot.model.GetJobDocumentResponse(document.map(value => value))
    def document: Option[JobDocument]
    def getDocument: ZIO[Any, AwsError, JobDocument] =
      AwsError.unwrapOptionField("document", document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetJobDocumentResponse
  ) extends zio.aws.iot.model.GetJobDocumentResponse.ReadOnly {
    override val document: Option[JobDocument] = scala
      .Option(impl.document())
      .map(value => zio.aws.iot.model.primitives.JobDocument(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetJobDocumentResponse
  ): zio.aws.iot.model.GetJobDocumentResponse.ReadOnly = new Wrapper(impl)
}
