package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Percent,
  IndexName,
  AggregationField,
  QueryVersion,
  QueryString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetPercentilesRequest(
    indexName: Option[IndexName] = None,
    queryString: QueryString,
    aggregationField: Option[AggregationField] = None,
    queryVersion: Option[QueryVersion] = None,
    percents: Option[Iterable[Percent]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPercentilesRequest = {
    import GetPercentilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPercentilesRequest
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        aggregationField.map(value =>
          AggregationField.unwrap(value): java.lang.String
        )
      )(_.aggregationField)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .optionallyWith(
        percents.map(value =>
          value.map { item =>
            Percent.unwrap(item): java.lang.Double
          }.asJavaCollection
        )
      )(_.percents)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPercentilesRequest.ReadOnly =
    zio.aws.iot.model.GetPercentilesRequest.wrap(buildAwsValue())
}
object GetPercentilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPercentilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPercentilesRequest =
      zio.aws.iot.model.GetPercentilesRequest(
        indexName.map(value => value),
        queryString,
        aggregationField.map(value => value),
        queryVersion.map(value => value),
        percents.map(value => value)
      )
    def indexName: Option[IndexName]
    def queryString: QueryString
    def aggregationField: Option[AggregationField]
    def queryVersion: Option[QueryVersion]
    def percents: Option[List[Percent]]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getAggregationField: ZIO[Any, AwsError, AggregationField] =
      AwsError.unwrapOptionField("aggregationField", aggregationField)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
    def getPercents: ZIO[Any, AwsError, List[Percent]] =
      AwsError.unwrapOptionField("percents", percents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPercentilesRequest
  ) extends zio.aws.iot.model.GetPercentilesRequest.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: QueryString =
      zio.aws.iot.model.primitives.QueryString(impl.queryString())
    override val aggregationField: Option[AggregationField] = scala
      .Option(impl.aggregationField())
      .map(value => zio.aws.iot.model.primitives.AggregationField(value))
    override val queryVersion: Option[QueryVersion] = scala
      .Option(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
    override val percents: Option[List[Percent]] = scala
      .Option(impl.percents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.Percent(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPercentilesRequest
  ): zio.aws.iot.model.GetPercentilesRequest.ReadOnly = new Wrapper(impl)
}
