package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  PolicyArn,
  PolicyName,
  DateType,
  PolicyVersionId,
  PolicyDocument,
  GenerationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetPolicyResponse(
    policyName: Option[PolicyName] = None,
    policyArn: Option[PolicyArn] = None,
    policyDocument: Option[PolicyDocument] = None,
    defaultVersionId: Option[PolicyVersionId] = None,
    creationDate: Option[DateType] = None,
    lastModifiedDate: Option[DateType] = None,
    generationId: Option[GenerationId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetPolicyResponse = {
    import GetPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetPolicyResponse
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .optionallyWith(
        defaultVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        generationId.map(value => GenerationId.unwrap(value): java.lang.String)
      )(_.generationId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetPolicyResponse.ReadOnly =
    zio.aws.iot.model.GetPolicyResponse.wrap(buildAwsValue())
}
object GetPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetPolicyResponse =
      zio.aws.iot.model.GetPolicyResponse(
        policyName.map(value => value),
        policyArn.map(value => value),
        policyDocument.map(value => value),
        defaultVersionId.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        generationId.map(value => value)
      )
    def policyName: Option[PolicyName]
    def policyArn: Option[PolicyArn]
    def policyDocument: Option[PolicyDocument]
    def defaultVersionId: Option[PolicyVersionId]
    def creationDate: Option[DateType]
    def lastModifiedDate: Option[DateType]
    def generationId: Option[GenerationId]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getDefaultVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getGenerationId: ZIO[Any, AwsError, GenerationId] =
      AwsError.unwrapOptionField("generationId", generationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyResponse
  ) extends zio.aws.iot.model.GetPolicyResponse.ReadOnly {
    override val policyName: Option[PolicyName] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyArn: Option[PolicyArn] = scala
      .Option(impl.policyArn())
      .map(value => zio.aws.iot.model.primitives.PolicyArn(value))
    override val policyDocument: Option[PolicyDocument] = scala
      .Option(impl.policyDocument())
      .map(value => zio.aws.iot.model.primitives.PolicyDocument(value))
    override val defaultVersionId: Option[PolicyVersionId] = scala
      .Option(impl.defaultVersionId())
      .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val generationId: Option[GenerationId] = scala
      .Option(impl.generationId())
      .map(value => zio.aws.iot.model.primitives.GenerationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetPolicyResponse
  ): zio.aws.iot.model.GetPolicyResponse.ReadOnly = new Wrapper(impl)
}
