package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  QueryVersion,
  AggregationField,
  QueryString,
  IndexName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStatisticsRequest(
    indexName: Option[IndexName] = None,
    queryString: QueryString,
    aggregationField: Option[AggregationField] = None,
    queryVersion: Option[QueryVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetStatisticsRequest = {
    import GetStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetStatisticsRequest
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        aggregationField.map(value =>
          AggregationField.unwrap(value): java.lang.String
        )
      )(_.aggregationField)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetStatisticsRequest.ReadOnly =
    zio.aws.iot.model.GetStatisticsRequest.wrap(buildAwsValue())
}
object GetStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetStatisticsRequest =
      zio.aws.iot.model.GetStatisticsRequest(
        indexName.map(value => value),
        queryString,
        aggregationField.map(value => value),
        queryVersion.map(value => value)
      )
    def indexName: Option[IndexName]
    def queryString: QueryString
    def aggregationField: Option[AggregationField]
    def queryVersion: Option[QueryVersion]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getAggregationField: ZIO[Any, AwsError, AggregationField] =
      AwsError.unwrapOptionField("aggregationField", aggregationField)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetStatisticsRequest
  ) extends zio.aws.iot.model.GetStatisticsRequest.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: QueryString =
      zio.aws.iot.model.primitives.QueryString(impl.queryString())
    override val aggregationField: Option[AggregationField] = scala
      .Option(impl.aggregationField())
      .map(value => zio.aws.iot.model.primitives.AggregationField(value))
    override val queryVersion: Option[QueryVersion] = scala
      .Option(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetStatisticsRequest
  ): zio.aws.iot.model.GetStatisticsRequest.ReadOnly = new Wrapper(impl)
}
