package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.RuleName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTopicRuleRequest(ruleName: RuleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GetTopicRuleRequest = {
    import GetTopicRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GetTopicRuleRequest
      .builder()
      .ruleName(RuleName.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GetTopicRuleRequest.ReadOnly =
    zio.aws.iot.model.GetTopicRuleRequest.wrap(buildAwsValue())
}
object GetTopicRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GetTopicRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GetTopicRuleRequest =
      zio.aws.iot.model.GetTopicRuleRequest(ruleName)
    def ruleName: RuleName
    def getRuleName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GetTopicRuleRequest
  ) extends zio.aws.iot.model.GetTopicRuleRequest.ReadOnly {
    override val ruleName: RuleName =
      zio.aws.iot.model.primitives.RuleName(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GetTopicRuleRequest
  ): zio.aws.iot.model.GetTopicRuleRequest.ReadOnly = new Wrapper(impl)
}
