package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ThingGroupArn, ThingGroupName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GroupNameAndArn(
    groupName: Option[ThingGroupName] = None,
    groupArn: Option[ThingGroupArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.GroupNameAndArn = {
    import GroupNameAndArn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.GroupNameAndArn
      .builder()
      .optionallyWith(
        groupName.map(value => ThingGroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupArn.map(value => ThingGroupArn.unwrap(value): java.lang.String)
      )(_.groupArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.GroupNameAndArn.ReadOnly =
    zio.aws.iot.model.GroupNameAndArn.wrap(buildAwsValue())
}
object GroupNameAndArn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.GroupNameAndArn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.GroupNameAndArn =
      zio.aws.iot.model.GroupNameAndArn(
        groupName.map(value => value),
        groupArn.map(value => value)
      )
    def groupName: Option[ThingGroupName]
    def groupArn: Option[ThingGroupArn]
    def getGroupName: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupArn: ZIO[Any, AwsError, ThingGroupArn] =
      AwsError.unwrapOptionField("groupArn", groupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.GroupNameAndArn
  ) extends zio.aws.iot.model.GroupNameAndArn.ReadOnly {
    override val groupName: Option[ThingGroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val groupArn: Option[ThingGroupArn] = scala
      .Option(impl.groupArn())
      .map(value => zio.aws.iot.model.primitives.ThingGroupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.GroupNameAndArn
  ): zio.aws.iot.model.GroupNameAndArn.ReadOnly = new Wrapper(impl)
}
