package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AwsArn, BatchMode, MessageId, InputName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IotEventsAction(
    inputName: InputName,
    messageId: Option[MessageId] = None,
    batchMode: Option[BatchMode] = None,
    roleArn: AwsArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.IotEventsAction = {
    import IotEventsAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.IotEventsAction
      .builder()
      .inputName(InputName.unwrap(inputName): java.lang.String)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        batchMode.map(value => BatchMode.unwrap(value): java.lang.Boolean)
      )(_.batchMode)
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.IotEventsAction.ReadOnly =
    zio.aws.iot.model.IotEventsAction.wrap(buildAwsValue())
}
object IotEventsAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.IotEventsAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.IotEventsAction =
      zio.aws.iot.model.IotEventsAction(
        inputName,
        messageId.map(value => value),
        batchMode.map(value => value),
        roleArn
      )
    def inputName: InputName
    def messageId: Option[MessageId]
    def batchMode: Option[BatchMode]
    def roleArn: AwsArn
    def getInputName: ZIO[Any, Nothing, InputName] = ZIO.succeed(inputName)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getBatchMode: ZIO[Any, AwsError, BatchMode] =
      AwsError.unwrapOptionField("batchMode", batchMode)
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.IotEventsAction
  ) extends zio.aws.iot.model.IotEventsAction.ReadOnly {
    override val inputName: InputName =
      zio.aws.iot.model.primitives.InputName(impl.inputName())
    override val messageId: Option[MessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.iot.model.primitives.MessageId(value))
    override val batchMode: Option[BatchMode] = scala
      .Option(impl.batchMode())
      .map(value => zio.aws.iot.model.primitives.BatchMode(value))
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.IotEventsAction
  ): zio.aws.iot.model.IotEventsAction.ReadOnly = new Wrapper(impl)
}
