package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingArn,
  DateType,
  ApproximateSecondsBeforeTimedOut,
  ExecutionNumber,
  VersionNumber,
  Forced,
  JobId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class JobExecution(
    jobId: Option[JobId] = None,
    status: Option[zio.aws.iot.model.JobExecutionStatus] = None,
    forceCanceled: Option[Forced] = None,
    statusDetails: Option[zio.aws.iot.model.JobExecutionStatusDetails] = None,
    thingArn: Option[ThingArn] = None,
    queuedAt: Option[DateType] = None,
    startedAt: Option[DateType] = None,
    lastUpdatedAt: Option[DateType] = None,
    executionNumber: Option[ExecutionNumber] = None,
    versionNumber: Option[VersionNumber] = None,
    approximateSecondsBeforeTimedOut: Option[ApproximateSecondsBeforeTimedOut] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecution = {
    import JobExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecution
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        forceCanceled.map(value => Forced.unwrap(value): java.lang.Boolean)
      )(_.forceCanceled)
      .optionallyWith(statusDetails.map(value => value.buildAwsValue()))(
        _.statusDetails
      )
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(queuedAt.map(value => DateType.unwrap(value): Instant))(
        _.queuedAt
      )
      .optionallyWith(startedAt.map(value => DateType.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        executionNumber.map(value =>
          ExecutionNumber.unwrap(value): java.lang.Long
        )
      )(_.executionNumber)
      .optionallyWith(
        versionNumber.map(value => VersionNumber.unwrap(value): java.lang.Long)
      )(_.versionNumber)
      .optionallyWith(
        approximateSecondsBeforeTimedOut.map(value =>
          ApproximateSecondsBeforeTimedOut.unwrap(value): java.lang.Long
        )
      )(_.approximateSecondsBeforeTimedOut)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecution.ReadOnly =
    zio.aws.iot.model.JobExecution.wrap(buildAwsValue())
}
object JobExecution {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.JobExecution] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecution =
      zio.aws.iot.model.JobExecution(
        jobId.map(value => value),
        status.map(value => value),
        forceCanceled.map(value => value),
        statusDetails.map(value => value.asEditable),
        thingArn.map(value => value),
        queuedAt.map(value => value),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        executionNumber.map(value => value),
        versionNumber.map(value => value),
        approximateSecondsBeforeTimedOut.map(value => value)
      )
    def jobId: Option[JobId]
    def status: Option[zio.aws.iot.model.JobExecutionStatus]
    def forceCanceled: Option[Forced]
    def statusDetails
        : Option[zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly]
    def thingArn: Option[ThingArn]
    def queuedAt: Option[DateType]
    def startedAt: Option[DateType]
    def lastUpdatedAt: Option[DateType]
    def executionNumber: Option[ExecutionNumber]
    def versionNumber: Option[VersionNumber]
    def approximateSecondsBeforeTimedOut
        : Option[ApproximateSecondsBeforeTimedOut]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getForceCanceled: ZIO[Any, AwsError, Forced] =
      AwsError.unwrapOptionField("forceCanceled", forceCanceled)
    def getStatusDetails: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly
    ] = AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getQueuedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("queuedAt", queuedAt)
    def getStartedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getExecutionNumber: ZIO[Any, AwsError, ExecutionNumber] =
      AwsError.unwrapOptionField("executionNumber", executionNumber)
    def getVersionNumber: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getApproximateSecondsBeforeTimedOut
        : ZIO[Any, AwsError, ApproximateSecondsBeforeTimedOut] =
      AwsError.unwrapOptionField(
        "approximateSecondsBeforeTimedOut",
        approximateSecondsBeforeTimedOut
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecution
  ) extends zio.aws.iot.model.JobExecution.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.iot.model.primitives.JobId(value))
    override val status: Option[zio.aws.iot.model.JobExecutionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.JobExecutionStatus.wrap(value))
    override val forceCanceled: Option[Forced] = scala
      .Option(impl.forceCanceled())
      .map(value => zio.aws.iot.model.primitives.Forced(value))
    override val statusDetails
        : Option[zio.aws.iot.model.JobExecutionStatusDetails.ReadOnly] = scala
      .Option(impl.statusDetails())
      .map(value => zio.aws.iot.model.JobExecutionStatusDetails.wrap(value))
    override val thingArn: Option[ThingArn] = scala
      .Option(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
    override val queuedAt: Option[DateType] = scala
      .Option(impl.queuedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val startedAt: Option[DateType] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Option[DateType] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val executionNumber: Option[ExecutionNumber] = scala
      .Option(impl.executionNumber())
      .map(value => zio.aws.iot.model.primitives.ExecutionNumber(value))
    override val versionNumber: Option[VersionNumber] = scala
      .Option(impl.versionNumber())
      .map(value => zio.aws.iot.model.primitives.VersionNumber(value))
    override val approximateSecondsBeforeTimedOut
        : Option[ApproximateSecondsBeforeTimedOut] = scala
      .Option(impl.approximateSecondsBeforeTimedOut())
      .map(value =>
        zio.aws.iot.model.primitives.ApproximateSecondsBeforeTimedOut(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecution
  ): zio.aws.iot.model.JobExecution.ReadOnly = new Wrapper(impl)
}
