package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobExecutionSummaryForJob(
    thingArn: Option[ThingArn] = None,
    jobExecutionSummary: Option[zio.aws.iot.model.JobExecutionSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJob = {
    import JobExecutionSummaryForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJob
      .builder()
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(jobExecutionSummary.map(value => value.buildAwsValue()))(
        _.jobExecutionSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecutionSummaryForJob.ReadOnly =
    zio.aws.iot.model.JobExecutionSummaryForJob.wrap(buildAwsValue())
}
object JobExecutionSummaryForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecutionSummaryForJob =
      zio.aws.iot.model.JobExecutionSummaryForJob(
        thingArn.map(value => value),
        jobExecutionSummary.map(value => value.asEditable)
      )
    def thingArn: Option[ThingArn]
    def jobExecutionSummary
        : Option[zio.aws.iot.model.JobExecutionSummary.ReadOnly]
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getJobExecutionSummary
        : ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionSummary.ReadOnly] =
      AwsError.unwrapOptionField("jobExecutionSummary", jobExecutionSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJob
  ) extends zio.aws.iot.model.JobExecutionSummaryForJob.ReadOnly {
    override val thingArn: Option[ThingArn] = scala
      .Option(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
    override val jobExecutionSummary
        : Option[zio.aws.iot.model.JobExecutionSummary.ReadOnly] = scala
      .Option(impl.jobExecutionSummary())
      .map(value => zio.aws.iot.model.JobExecutionSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJob
  ): zio.aws.iot.model.JobExecutionSummaryForJob.ReadOnly = new Wrapper(impl)
}
