package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.MaxJobExecutionsPerMin
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class JobExecutionsRolloutConfig(
    maximumPerMinute: Option[MaxJobExecutionsPerMin] = None,
    exponentialRate: Option[zio.aws.iot.model.ExponentialRolloutRate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig = {
    import JobExecutionsRolloutConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig
      .builder()
      .optionallyWith(
        maximumPerMinute.map(value =>
          MaxJobExecutionsPerMin.unwrap(value): Integer
        )
      )(_.maximumPerMinute)
      .optionallyWith(exponentialRate.map(value => value.buildAwsValue()))(
        _.exponentialRate
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly =
    zio.aws.iot.model.JobExecutionsRolloutConfig.wrap(buildAwsValue())
}
object JobExecutionsRolloutConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobExecutionsRolloutConfig =
      zio.aws.iot.model.JobExecutionsRolloutConfig(
        maximumPerMinute.map(value => value),
        exponentialRate.map(value => value.asEditable)
      )
    def maximumPerMinute: Option[MaxJobExecutionsPerMin]
    def exponentialRate
        : Option[zio.aws.iot.model.ExponentialRolloutRate.ReadOnly]
    def getMaximumPerMinute: ZIO[Any, AwsError, MaxJobExecutionsPerMin] =
      AwsError.unwrapOptionField("maximumPerMinute", maximumPerMinute)
    def getExponentialRate: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ExponentialRolloutRate.ReadOnly
    ] = AwsError.unwrapOptionField("exponentialRate", exponentialRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig
  ) extends zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly {
    override val maximumPerMinute: Option[MaxJobExecutionsPerMin] = scala
      .Option(impl.maximumPerMinute())
      .map(value => zio.aws.iot.model.primitives.MaxJobExecutionsPerMin(value))
    override val exponentialRate
        : Option[zio.aws.iot.model.ExponentialRolloutRate.ReadOnly] = scala
      .Option(impl.exponentialRate())
      .map(value => zio.aws.iot.model.ExponentialRolloutRate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobExecutionsRolloutConfig
  ): zio.aws.iot.model.JobExecutionsRolloutConfig.ReadOnly = new Wrapper(impl)
}
