package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DateType,
  JobDescription,
  JobTemplateId,
  JobTemplateArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class JobTemplateSummary(
    jobTemplateArn: Option[JobTemplateArn] = None,
    jobTemplateId: Option[JobTemplateId] = None,
    description: Option[JobDescription] = None,
    createdAt: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.JobTemplateSummary = {
    import JobTemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.JobTemplateSummary
      .builder()
      .optionallyWith(
        jobTemplateArn.map(value =>
          JobTemplateArn.unwrap(value): java.lang.String
        )
      )(_.jobTemplateArn)
      .optionallyWith(
        jobTemplateId.map(value =>
          JobTemplateId.unwrap(value): java.lang.String
        )
      )(_.jobTemplateId)
      .optionallyWith(
        description.map(value => JobDescription.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.JobTemplateSummary.ReadOnly =
    zio.aws.iot.model.JobTemplateSummary.wrap(buildAwsValue())
}
object JobTemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.JobTemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.JobTemplateSummary =
      zio.aws.iot.model.JobTemplateSummary(
        jobTemplateArn.map(value => value),
        jobTemplateId.map(value => value),
        description.map(value => value),
        createdAt.map(value => value)
      )
    def jobTemplateArn: Option[JobTemplateArn]
    def jobTemplateId: Option[JobTemplateId]
    def description: Option[JobDescription]
    def createdAt: Option[DateType]
    def getJobTemplateArn: ZIO[Any, AwsError, JobTemplateArn] =
      AwsError.unwrapOptionField("jobTemplateArn", jobTemplateArn)
    def getJobTemplateId: ZIO[Any, AwsError, JobTemplateId] =
      AwsError.unwrapOptionField("jobTemplateId", jobTemplateId)
    def getDescription: ZIO[Any, AwsError, JobDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.JobTemplateSummary
  ) extends zio.aws.iot.model.JobTemplateSummary.ReadOnly {
    override val jobTemplateArn: Option[JobTemplateArn] = scala
      .Option(impl.jobTemplateArn())
      .map(value => zio.aws.iot.model.primitives.JobTemplateArn(value))
    override val jobTemplateId: Option[JobTemplateId] = scala
      .Option(impl.jobTemplateId())
      .map(value => zio.aws.iot.model.primitives.JobTemplateId(value))
    override val description: Option[JobDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.JobDescription(value))
    override val createdAt: Option[DateType] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.JobTemplateSummary
  ): zio.aws.iot.model.JobTemplateSummary.ReadOnly = new Wrapper(impl)
}
