package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  AuditTaskId,
  NextToken,
  Timestamp,
  AuditCheckName,
  MaxResults,
  ListSuppressedFindings
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAuditFindingsRequest(
    taskId: Option[AuditTaskId] = None,
    checkName: Option[AuditCheckName] = None,
    resourceIdentifier: Option[zio.aws.iot.model.ResourceIdentifier] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    listSuppressedFindings: Option[ListSuppressedFindings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest = {
    import ListAuditFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest
      .builder()
      .optionallyWith(
        taskId.map(value => AuditTaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .optionallyWith(
        checkName.map(value => AuditCheckName.unwrap(value): java.lang.String)
      )(_.checkName)
      .optionallyWith(resourceIdentifier.map(value => value.buildAwsValue()))(
        _.resourceIdentifier
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        listSuppressedFindings.map(value =>
          ListSuppressedFindings.unwrap(value): java.lang.Boolean
        )
      )(_.listSuppressedFindings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuditFindingsRequest.ReadOnly =
    zio.aws.iot.model.ListAuditFindingsRequest.wrap(buildAwsValue())
}
object ListAuditFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditFindingsRequest =
      zio.aws.iot.model.ListAuditFindingsRequest(
        taskId.map(value => value),
        checkName.map(value => value),
        resourceIdentifier.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        listSuppressedFindings.map(value => value)
      )
    def taskId: Option[AuditTaskId]
    def checkName: Option[AuditCheckName]
    def resourceIdentifier
        : Option[zio.aws.iot.model.ResourceIdentifier.ReadOnly]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def listSuppressedFindings: Option[ListSuppressedFindings]
    def getTaskId: ZIO[Any, AwsError, AuditTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
    def getCheckName: ZIO[Any, AwsError, AuditCheckName] =
      AwsError.unwrapOptionField("checkName", checkName)
    def getResourceIdentifier
        : ZIO[Any, AwsError, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getListSuppressedFindings: ZIO[Any, AwsError, ListSuppressedFindings] =
      AwsError.unwrapOptionField(
        "listSuppressedFindings",
        listSuppressedFindings
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest
  ) extends zio.aws.iot.model.ListAuditFindingsRequest.ReadOnly {
    override val taskId: Option[AuditTaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.AuditTaskId(value))
    override val checkName: Option[AuditCheckName] = scala
      .Option(impl.checkName())
      .map(value => zio.aws.iot.model.primitives.AuditCheckName(value))
    override val resourceIdentifier
        : Option[zio.aws.iot.model.ResourceIdentifier.ReadOnly] = scala
      .Option(impl.resourceIdentifier())
      .map(value => zio.aws.iot.model.ResourceIdentifier.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.iot.model.primitives.Timestamp(value))
    override val listSuppressedFindings: Option[ListSuppressedFindings] = scala
      .Option(impl.listSuppressedFindings())
      .map(value => zio.aws.iot.model.primitives.ListSuppressedFindings(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest
  ): zio.aws.iot.model.ListAuditFindingsRequest.ReadOnly = new Wrapper(impl)
}
