package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  NextToken,
  MaxResults,
  FindingId,
  MitigationActionsTaskId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAuditMitigationActionsExecutionsRequest(
    taskId: MitigationActionsTaskId,
    actionStatus: Option[
      zio.aws.iot.model.AuditMitigationActionsExecutionStatus
    ] = None,
    findingId: FindingId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest = {
    import ListAuditMitigationActionsExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest
      .builder()
      .taskId(MitigationActionsTaskId.unwrap(taskId): java.lang.String)
      .optionallyWith(actionStatus.map(value => value.unwrap))(_.actionStatus)
      .findingId(FindingId.unwrap(findingId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest.ReadOnly =
    zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest
      .wrap(buildAwsValue())
}
object ListAuditMitigationActionsExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest =
      zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest(
        taskId,
        actionStatus.map(value => value),
        findingId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def taskId: MitigationActionsTaskId
    def actionStatus
        : Option[zio.aws.iot.model.AuditMitigationActionsExecutionStatus]
    def findingId: FindingId
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getTaskId: ZIO[Any, Nothing, MitigationActionsTaskId] =
      ZIO.succeed(taskId)
    def getActionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.AuditMitigationActionsExecutionStatus
    ] = AwsError.unwrapOptionField("actionStatus", actionStatus)
    def getFindingId: ZIO[Any, Nothing, FindingId] = ZIO.succeed(findingId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest
  ) extends zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest.ReadOnly {
    override val taskId: MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId(impl.taskId())
    override val actionStatus
        : Option[zio.aws.iot.model.AuditMitigationActionsExecutionStatus] =
      scala
        .Option(impl.actionStatus())
        .map(value =>
          zio.aws.iot.model.AuditMitigationActionsExecutionStatus.wrap(value)
        )
    override val findingId: FindingId =
      zio.aws.iot.model.primitives.FindingId(impl.findingId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest
  ): zio.aws.iot.model.ListAuditMitigationActionsExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
