package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  MaxResults,
  NextToken,
  AscendingOrder,
  AuditCheckName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAuditSuppressionsRequest(
    checkName: Option[AuditCheckName] = None,
    resourceIdentifier: Option[zio.aws.iot.model.ResourceIdentifier] = None,
    ascendingOrder: Option[AscendingOrder] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest = {
    import ListAuditSuppressionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest
      .builder()
      .optionallyWith(
        checkName.map(value => AuditCheckName.unwrap(value): java.lang.String)
      )(_.checkName)
      .optionallyWith(resourceIdentifier.map(value => value.buildAwsValue()))(
        _.resourceIdentifier
      )
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuditSuppressionsRequest.ReadOnly =
    zio.aws.iot.model.ListAuditSuppressionsRequest.wrap(buildAwsValue())
}
object ListAuditSuppressionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuditSuppressionsRequest =
      zio.aws.iot.model.ListAuditSuppressionsRequest(
        checkName.map(value => value),
        resourceIdentifier.map(value => value.asEditable),
        ascendingOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def checkName: Option[AuditCheckName]
    def resourceIdentifier
        : Option[zio.aws.iot.model.ResourceIdentifier.ReadOnly]
    def ascendingOrder: Option[AscendingOrder]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getCheckName: ZIO[Any, AwsError, AuditCheckName] =
      AwsError.unwrapOptionField("checkName", checkName)
    def getResourceIdentifier
        : ZIO[Any, AwsError, zio.aws.iot.model.ResourceIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest
  ) extends zio.aws.iot.model.ListAuditSuppressionsRequest.ReadOnly {
    override val checkName: Option[AuditCheckName] = scala
      .Option(impl.checkName())
      .map(value => zio.aws.iot.model.primitives.AuditCheckName(value))
    override val resourceIdentifier
        : Option[zio.aws.iot.model.ResourceIdentifier.ReadOnly] = scala
      .Option(impl.resourceIdentifier())
      .map(value => zio.aws.iot.model.ResourceIdentifier.wrap(value))
    override val ascendingOrder: Option[AscendingOrder] = scala
      .Option(impl.ascendingOrder())
      .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest
  ): zio.aws.iot.model.ListAuditSuppressionsRequest.ReadOnly = new Wrapper(impl)
}
