package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{AscendingOrder, Marker, PageSize}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAuthorizersRequest(
    pageSize: Option[PageSize] = None,
    marker: Option[Marker] = None,
    ascendingOrder: Option[AscendingOrder] = None,
    status: Option[zio.aws.iot.model.AuthorizerStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListAuthorizersRequest = {
    import ListAuthorizersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListAuthorizersRequest
      .builder()
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListAuthorizersRequest.ReadOnly =
    zio.aws.iot.model.ListAuthorizersRequest.wrap(buildAwsValue())
}
object ListAuthorizersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListAuthorizersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListAuthorizersRequest =
      zio.aws.iot.model.ListAuthorizersRequest(
        pageSize.map(value => value),
        marker.map(value => value),
        ascendingOrder.map(value => value),
        status.map(value => value)
      )
    def pageSize: Option[PageSize]
    def marker: Option[Marker]
    def ascendingOrder: Option[AscendingOrder]
    def status: Option[zio.aws.iot.model.AuthorizerStatus]
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListAuthorizersRequest
  ) extends zio.aws.iot.model.ListAuthorizersRequest.ReadOnly {
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val ascendingOrder: Option[AscendingOrder] = scala
      .Option(impl.ascendingOrder())
      .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
    override val status: Option[zio.aws.iot.model.AuthorizerStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.AuthorizerStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListAuthorizersRequest
  ): zio.aws.iot.model.ListAuthorizersRequest.ReadOnly = new Wrapper(impl)
}
