package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  BillingGroupName,
  RegistryMaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBillingGroupsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[RegistryMaxResults] = None,
    namePrefixFilter: Option[BillingGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest = {
    import ListBillingGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        namePrefixFilter.map(value =>
          BillingGroupName.unwrap(value): java.lang.String
        )
      )(_.namePrefixFilter)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListBillingGroupsRequest.ReadOnly =
    zio.aws.iot.model.ListBillingGroupsRequest.wrap(buildAwsValue())
}
object ListBillingGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListBillingGroupsRequest =
      zio.aws.iot.model.ListBillingGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        namePrefixFilter.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[RegistryMaxResults]
    def namePrefixFilter: Option[BillingGroupName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamePrefixFilter: ZIO[Any, AwsError, BillingGroupName] =
      AwsError.unwrapOptionField("namePrefixFilter", namePrefixFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest
  ) extends zio.aws.iot.model.ListBillingGroupsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[RegistryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val namePrefixFilter: Option[BillingGroupName] = scala
      .Option(impl.namePrefixFilter())
      .map(value => zio.aws.iot.model.primitives.BillingGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest
  ): zio.aws.iot.model.ListBillingGroupsRequest.ReadOnly = new Wrapper(impl)
}
