package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.Marker
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCaCertificatesResponse(
    certificates: Option[Iterable[zio.aws.iot.model.CACertificate]] = None,
    nextMarker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse = {
    import ListCaCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .optionallyWith(
        nextMarker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly =
    zio.aws.iot.model.ListCaCertificatesResponse.wrap(buildAwsValue())
}
object ListCaCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListCaCertificatesResponse =
      zio.aws.iot.model.ListCaCertificatesResponse(
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def certificates: Option[List[zio.aws.iot.model.CACertificate.ReadOnly]]
    def nextMarker: Option[Marker]
    def getCertificates
        : ZIO[Any, AwsError, List[zio.aws.iot.model.CACertificate.ReadOnly]] =
      AwsError.unwrapOptionField("certificates", certificates)
    def getNextMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse
  ) extends zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly {
    override val certificates
        : Option[List[zio.aws.iot.model.CACertificate.ReadOnly]] = scala
      .Option(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.CACertificate.wrap(item)
        }.toList
      )
    override val nextMarker: Option[Marker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse
  ): zio.aws.iot.model.ListCaCertificatesResponse.ReadOnly = new Wrapper(impl)
}
