package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, MetricName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListCustomMetricsResponse(
    metricNames: Option[Iterable[MetricName]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse = {
    import ListCustomMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse
      .builder()
      .optionallyWith(
        metricNames.map(value =>
          value.map { item =>
            MetricName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metricNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListCustomMetricsResponse.ReadOnly =
    zio.aws.iot.model.ListCustomMetricsResponse.wrap(buildAwsValue())
}
object ListCustomMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListCustomMetricsResponse =
      zio.aws.iot.model.ListCustomMetricsResponse(
        metricNames.map(value => value),
        nextToken.map(value => value)
      )
    def metricNames: Option[List[MetricName]]
    def nextToken: Option[NextToken]
    def getMetricNames: ZIO[Any, AwsError, List[MetricName]] =
      AwsError.unwrapOptionField("metricNames", metricNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse
  ) extends zio.aws.iot.model.ListCustomMetricsResponse.ReadOnly {
    override val metricNames: Option[List[MetricName]] = scala
      .Option(impl.metricNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.MetricName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse
  ): zio.aws.iot.model.ListCustomMetricsResponse.ReadOnly = new Wrapper(impl)
}
