package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDetectMitigationActionsExecutionsResponse(
    actionsExecutions: Option[
      Iterable[zio.aws.iot.model.DetectMitigationActionExecution]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse = {
    import ListDetectMitigationActionsExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse
      .builder()
      .optionallyWith(
        actionsExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionsExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.ReadOnly =
    zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse
      .wrap(buildAwsValue())
}
object ListDetectMitigationActionsExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse =
      zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse(
        actionsExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def actionsExecutions: Option[
      List[zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getActionsExecutions: ZIO[Any, AwsError, List[
      zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly
    ]] = AwsError.unwrapOptionField("actionsExecutions", actionsExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse
  ) extends zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.ReadOnly {
    override val actionsExecutions: Option[
      List[zio.aws.iot.model.DetectMitigationActionExecution.ReadOnly]
    ] = scala
      .Option(impl.actionsExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.DetectMitigationActionExecution.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse
  ): zio.aws.iot.model.ListDetectMitigationActionsExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
